<?php
/**
 * Database Configuration
 * Connection settings for MySQL database
 */

// Database credentials
define('DB_HOST', 'localhost');      // Database host (usually localhost for local development)
define('DB_USER', 'root');           // Database username (default root in XAMPP)
define('DB_PASS', '');               // Database password (usually empty in XAMPP)
define('DB_NAME', 'cleaning_service'); // Database name

// MySQLi Connection
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

// Check connection
if ($conn->connect_error) {
    // Check if database doesn't exist
    if (strpos($conn->connect_error, 'Unknown database') !== false) {
        echo "<div style='padding: 20px; background: #fff3cd; border: 1px solid #ffc107; margin: 20px; border-radius: 5px;'>";
        echo "<h3 style='color: #856404; margin-top: 0;'>⚠️ Database Setup Required</h3>";
        echo "<p>The database has not been created yet. Please run the setup script to initialize the database and tables.</p>";
        echo "<p><strong>Step 1:</strong> Click the button below to set up the database</p>";
        echo "<p><a href='setup_database.php' style='display: inline-block; padding: 10px 20px; background: #ffc107; color: #000; text-decoration: none; border-radius: 5px; font-weight: bold;'>Run Database Setup</a></p>";
        echo "<p><strong>Step 2:</strong> After setup completes, refresh this page</p>";
        echo "</div>";
        exit;
    }
    die("Connection Failed: " . $conn->connect_error);
}

// Set charset to utf8
$conn->set_charset("utf8");

// Optional: Set timezone
date_default_timezone_set('UTC');

// Email Configuration
if (!defined('MAIL_HOST')) {
    define('MAIL_HOST', 'smtp.gmail.com');
    define('MAIL_PORT', 587);
    define('MAIL_USERNAME', 'mohamedhalith117@gmail.com');
    define('MAIL_PASSWORD', 'arctfbzmhhddkfqr');
    define('MAIL_FROM_NAME', 'Cleaning Service');
}

// OTP Settings
if (!defined('OTP_LENGTH')) {
    define('OTP_LENGTH', 6);
    define('OTP_EXPIRY_MINUTES', 10);
}

?>
